package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class BackgroundColorPopUpPanel extends JPanel {
	
	private int redComponent = -1;
	private int greenComponent = -1;
	private int blueComponent = -1;
	
	private JTextArea redText = null;
	private JTextArea greenText = null;
	private JTextArea blueText = null;
	
	private ColorCanvas previewCanvas = null;
	
	private Color resultColor = null;
	private JDialog parent = null;
	
	private JCheckBox shouldUseForAllImages = null;
	
	public BackgroundColorPopUpPanel(Color origColor, JDialog theParent, boolean shouldHaveAllCheckBox) {
		
		parent = theParent;
		
		parent.addWindowListener(new WindowAdapter() {
			
			public void windowClosing(WindowEvent arg0) {
				uponCancelClick(true);
			}

		});
		
		parent.setSize(650, 350);
		parent.setModal(true);
		
		if(origColor != null) {
			redComponent = origColor.getRed();
			greenComponent = origColor.getGreen();
			blueComponent = origColor.getBlue();
		}
		
		setLayout(new BorderLayout());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				uponOkClick();
			}
			
		});
		
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				uponCancelClick(false);
			}
			
		});
		
		
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new BorderLayout());
		
		lowerPanel.add(cancelButton, BorderLayout.WEST);
		lowerPanel.add(okButton, BorderLayout.EAST);
		
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(2, 1));
		
		JPanel mainUpperPanel = new JPanel();
		
		BorderLayout mainUpperLayout = new BorderLayout();
//		GridBagConstraints mainUpperConstraints = new GridBagConstraints();
		
//		mainUpperConstraints.fill = GridBagConstraints.BOTH;
//		mainUpperConstraints.weightx = 30.0;
//		mainUpperConstraints.weighty = 1.0;
//		mainUpperConstraints.gridwidth = 4;
//		mainUpperConstraints.gridheight = 2;
		
		
		previewCanvas = new ColorCanvas();
		
		Border innerCanvasBorder = BorderFactory.createLineBorder(new Color(100, 100, 100));
		TitledBorder canvasBorder = BorderFactory.createTitledBorder(innerCanvasBorder);
		canvasBorder.setTitle("Color Preview");
		previewCanvas.setBorder(canvasBorder);
		previewCanvas.setPreferredSize(new Dimension(150, 100));
		previewCanvas.setMaximumSize(new Dimension(150, 100));
		previewCanvas.setMinimumSize(new Dimension(150, 100));
		if(origColor != null) 
			previewCanvas.setColor(origColor);
		
		mainUpperPanel.setLayout(mainUpperLayout);
		
//		mainUpperLayout.setConstraints(previewCanvas, mainUpperConstraints);
		mainUpperPanel.add(previewCanvas, BorderLayout.WEST);
		
//		JPanel mainUpperPanelRight = new JPanel();
//		GridLayout mainUpperPanelRightLayout = new GridLayout(2, 1);
//		mainUpperPanelRight.setLayout(mainUpperPanelRightLayout);
		
		JPanel labelsAndTextAreasPanel = new JPanel();
		GridBagLayout labelsAndTextAreasLayout = new GridBagLayout();
		GridBagConstraints labelsAndTextAreasConstraints = new GridBagConstraints();
		labelsAndTextAreasPanel.setLayout(labelsAndTextAreasLayout);
		
		JPanel dummyFiller1 = new JPanel();
		
		labelsAndTextAreasConstraints.gridheight = 1;
		labelsAndTextAreasConstraints.gridwidth = GridBagConstraints.REMAINDER;
		labelsAndTextAreasConstraints.weightx = 1;
		labelsAndTextAreasConstraints.weighty = 1;
		labelsAndTextAreasLayout.setConstraints(dummyFiller1, labelsAndTextAreasConstraints);
		
		labelsAndTextAreasPanel.add(dummyFiller1);
//		JPanel dummyFiller2 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller2);
//		JPanel dummyFiller3 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller3);
//		JPanel dummyFiller4 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller4);
//		JPanel dummyFiller5 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller5);
//		JPanel dummyFiller6 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller6);
//		JPanel dummyFiller7 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller7);
		
		
		
		JPanel redLabelPanel = new JPanel();
		redLabelPanel.setLayout(new FlowLayout());
		JLabel redLabel = new JLabel("Red: ");
		redLabelPanel.add(redLabel);
		labelsAndTextAreasConstraints.gridheight = 1;
		labelsAndTextAreasConstraints.gridwidth = 1;
		labelsAndTextAreasConstraints.weightx = 1;
		labelsAndTextAreasConstraints.weighty = 1;
		labelsAndTextAreasLayout.setConstraints(redLabelPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(redLabelPanel);
		
		JPanel redTextPanel = new JPanel();
//		JPanel innerRedTextPanel = new JPanel();
//		innerRedTextPanel.setLayout(new FlowLayout());
		redTextPanel.setLayout(new FlowLayout());
		redText = new JTextArea();
		redText.setColumns(3);
		redText.setSize(37, 20);
		redText.setMinimumSize(new Dimension(37, 20));
		redText.setPreferredSize(new Dimension(37, 20));
		redText.setMaximumSize(new Dimension(37, 20));
		Border redTextBorder = BorderFactory.createLoweredBevelBorder();
		redText.setBorder(redTextBorder);
//		innerRedTextPanel.add(redText);
		redTextPanel.add(redText);
//		mainUpperLayout.setConstraints(redTextPanel, mainUpperConstraints);
		labelsAndTextAreasLayout.setConstraints(redTextPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(redTextPanel);
//		redText.addCaretListener(new CaretListener() {
//
//			public void caretUpdate(CaretEvent arg0) {
//				redColorFieldChanged();
//			}
//			
//		});

		JPanel greenLabelPanel = new JPanel();
		greenLabelPanel.setLayout(new FlowLayout());
		JLabel greenLabel = new JLabel("Green: ");
		greenLabelPanel.add(greenLabel);
//		mainUpperConstraints.weightx = 1.0;
//		mainUpperLayout.setConstraints(greenLabelPanel, mainUpperConstraints);
		labelsAndTextAreasLayout.setConstraints(greenLabelPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(greenLabelPanel);
		
		JPanel greenTextPanel = new JPanel();
//		JPanel innerGreenTextPanel = new JPanel();
//		innerGreenTextPanel.setLayout(new FlowLayout());
		greenTextPanel.setLayout(new FlowLayout());
		greenText = new JTextArea();
		greenText.setColumns(3);
		greenText.setSize(37, 20);
		greenText.setMinimumSize(new Dimension(37, 20));
		greenText.setPreferredSize(new Dimension(37, 20));
		greenText.setMaximumSize(new Dimension(37, 20));
		Border greenTextBorder = BorderFactory.createLoweredBevelBorder();
		greenText.setBorder(greenTextBorder);
//		innerGreenTextPanel.add(greenText);
		greenTextPanel.add(greenText);
//		mainUpperLayout.setConstraints(greenTextPanel, mainUpperConstraints);
		labelsAndTextAreasLayout.setConstraints(greenTextPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(greenTextPanel);
//		greenText.addCaretListener(new CaretListener() {
//
//			public void caretUpdate(CaretEvent arg0) {
//				greenColorFieldChanged();
//			}
//			
//		});

		JPanel blueLabelPanel = new JPanel();
		blueLabelPanel.setLayout(new FlowLayout());
		JLabel blueLabel = new JLabel("Blue: ");
		blueLabelPanel.add(blueLabel);
//		mainUpperConstraints.weightx = 1.0;
//		mainUpperConstraints.gridwidth = GridBagConstraints.RELATIVE;
//		mainUpperLayout.setConstraints(blueLabelPanel, mainUpperConstraints);
		labelsAndTextAreasConstraints.gridwidth = GridBagConstraints.RELATIVE;
		labelsAndTextAreasLayout.setConstraints(blueLabelPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(blueLabelPanel);
		
		JPanel blueTextPanel = new JPanel();
//		JPanel innerBlueTextPanel = new JPanel();
//		innerBlueTextPanel.setLayout(new FlowLayout());
		blueTextPanel.setLayout(new FlowLayout());
		blueText = new JTextArea();
		blueText.setColumns(3);
		blueText.setSize(37, 20);
		blueText.setMinimumSize(new Dimension(37, 20));
		blueText.setPreferredSize(new Dimension(37, 20));
		blueText.setMaximumSize(new Dimension(37, 20));
		Border blueTextBorder = BorderFactory.createLoweredBevelBorder();
		blueText.setBorder(blueTextBorder);
//		innerBlueTextPanel.add(blueText);
		blueTextPanel.add(blueText);
//		mainUpperConstraints.gridwidth = GridBagConstraints.REMAINDER;
//		mainUpperLayout.setConstraints(blueTextPanel, mainUpperConstraints);
		labelsAndTextAreasConstraints.gridwidth = GridBagConstraints.REMAINDER;
		labelsAndTextAreasLayout.setConstraints(blueTextPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(blueTextPanel);
//		blueText.addCaretListener(new CaretListener() {
//
//			public void caretUpdate(CaretEvent arg0) {
//				blueColorFieldChanged();
//			}
//			
//		});
		
//		labelsAndTextAreasPanel.add(new JLabel("HELLO!"));
		
		JButton previewColorButton = new JButton("Preview Color from Manual RBG Fields");
		JPanel previewColorPanel = new JPanel();
		previewColorPanel.setLayout(new FlowLayout());
		previewColorPanel.add(previewColorButton);
		
		previewColorButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {

//				System.out.println("Dimensions of the red text field: " + redText.getSize().height + " high, " + redText.getSize().width + " across.");
				previewByNumbersButtonWasClicked();
			}
			
		});
		labelsAndTextAreasConstraints.gridwidth = 4;
		labelsAndTextAreasConstraints.weightx = 1;
		labelsAndTextAreasLayout.setConstraints(previewColorPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(previewColorPanel);
		
		
		JPanel useAllCheckPanel = new JPanel();
		
		if(shouldHaveAllCheckBox) {
			shouldUseForAllImages = new JCheckBox("Use for all images");
			useAllCheckPanel.add(shouldUseForAllImages);
		}
		
		labelsAndTextAreasConstraints.gridwidth = GridBagConstraints.REMAINDER;
		labelsAndTextAreasConstraints.weightx = 1;
		labelsAndTextAreasLayout.setConstraints(useAllCheckPanel, labelsAndTextAreasConstraints);
		labelsAndTextAreasPanel.add(useAllCheckPanel);
//		JPanel dummyFiller12 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller12);
//		JPanel dummyFiller13 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller13);
//		JPanel dummyFiller14 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller14);
//		JPanel dummyFiller15 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller15);
//		JPanel dummyFiller16 = new JPanel();
//		labelsAndTextAreasPanel.add(dummyFiller16);
		
		
		
//		mainUpperPanelRight.add(labelsAndTextAreasPanel);
//		
//		
//		JPanel buttonAreaPanel = new JPanel();
//		BoxLayout buttonAreaLayout = new BoxLayout(buttonAreaPanel, BoxLayout.X_AXIS);
//		buttonAreaPanel.setLayout(buttonAreaLayout);
//		
//		
//		
////		mainUpperConstraints.gridwidth = GridBagConstraints.RELATIVE;
////		mainUpperConstraints.weightx = 3.0;
////		mainUpperLayout.setConstraints(previewColorPanel, mainUpperConstraints);
////		buttonAreaPanel.add(previewColorPanel);
//		
//		JPanel fillerPanel1 = new JPanel();
////		mainUpperConstraints.gridwidth = GridBagConstraints.REMAINDER;
////		mainUpperLayout.setConstraints(fillerPanel, mainUpperConstraints);
//		buttonAreaPanel.add(fillerPanel1);
//		
//		JPanel fillerPanel2 = new JPanel();
//		buttonAreaPanel.add(fillerPanel2);
//		
//		JPanel fillerPanel3 = new JPanel();
//		buttonAreaPanel.add(fillerPanel3);
//		
//		JPanel fillerPanel4 = new JPanel();
//		buttonAreaPanel.add(fillerPanel4);
//		
//		
//		mainUpperPanelRight.add(buttonAreaPanel);
		mainUpperPanel.add(labelsAndTextAreasPanel, BorderLayout.CENTER);
		
		mainPanel.add(mainUpperPanel);
//		mainPanel.add(new JLabel("dummy placeholder"));
		
		
		JPanel defaultColorsPanel = new JPanel();
		GridLayout lowerPanelLayout = new GridLayout(3, 6);
		defaultColorsPanel.setLayout(lowerPanelLayout);
		
		JPanel redButtonPanel = new JPanel();
		FlowLayout redButtonLayout = new FlowLayout();
		redButtonPanel.setLayout(redButtonLayout);
		JButton redButton = new JButton("<html><font color='#FF0000'>Red</font></html>");
		redButton.addActionListener(new ColorButtonListener(new Color(255, 0, 0)));
		redButtonPanel.add(redButton);
		defaultColorsPanel.add(redButtonPanel);
		
		JPanel yellowButtonPanel = new JPanel();
		FlowLayout yellowButtonLayout = new FlowLayout();
		yellowButtonPanel.setLayout(yellowButtonLayout);
		JButton yellowButton = new JButton("<html><font color='#FFFF00'>Yellow</font></html>");
		yellowButton.addActionListener(new ColorButtonListener(new Color(255, 255, 0)));
		yellowButtonPanel.add(yellowButton);
		defaultColorsPanel.add(yellowButtonPanel);
		
		JPanel greenButtonPanel = new JPanel();
		FlowLayout greenButtonLayout = new FlowLayout();
		greenButtonPanel.setLayout(greenButtonLayout);
		JButton greenButton = new JButton("<html><font color='#00FF00'>Lime</font></html>");
		greenButton.addActionListener(new ColorButtonListener(new Color(0, 255, 0)));
		greenButtonPanel.add(greenButton);
		defaultColorsPanel.add(greenButtonPanel);
		
		JPanel cyanButtonPanel = new JPanel();
		FlowLayout cyanButtonLayout = new FlowLayout();
		cyanButtonPanel.setLayout(cyanButtonLayout);
		JButton cyanButton = new JButton("<html><font color='#00FFFF'>Cyan</font></html>");
		cyanButton.addActionListener(new ColorButtonListener(new Color(0, 255, 255)));
		cyanButtonPanel.add(cyanButton);
		defaultColorsPanel.add(cyanButtonPanel);
		
		JPanel blueButtonPanel = new JPanel();
		FlowLayout blueButtonLayout = new FlowLayout();
		blueButtonPanel.setLayout(blueButtonLayout);
		JButton blueButton = new JButton("<html><font color='#0000FF'>Blue</font></html>");
		blueButton.addActionListener(new ColorButtonListener(new Color(0, 0, 255)));
		blueButtonPanel.add(blueButton);
		defaultColorsPanel.add(blueButtonPanel);
		
		JPanel magentaButtonPanel = new JPanel();
		FlowLayout magentaButtonLayout = new FlowLayout();
		magentaButtonPanel.setLayout(magentaButtonLayout);
		JButton magentaButton = new JButton("<html><font color='#FF00FF'>Magenta</font></html>");
		magentaButton.addActionListener(new ColorButtonListener(new Color(255, 0, 255)));
		magentaButtonPanel.add(magentaButton);
		defaultColorsPanel.add(magentaButtonPanel);
		
		JPanel maroonButtonPanel = new JPanel();
		FlowLayout maroonButtonLayout = new FlowLayout();
		maroonButtonPanel.setLayout(maroonButtonLayout);
		JButton maroonButton = new JButton("<html><font color='#800000'>Maroon</font></html>");
		maroonButton.addActionListener(new ColorButtonListener(new Color(128, 0, 0)));
		maroonButtonPanel.add(maroonButton);
		defaultColorsPanel.add(maroonButtonPanel);
		
		JPanel goldButtonPanel = new JPanel();
		FlowLayout goldButtonLayout = new FlowLayout();
		goldButtonPanel.setLayout(goldButtonLayout);
		JButton goldButton = new JButton("<html><font color='#808000'>Olive</font></html>");
		goldButton.addActionListener(new ColorButtonListener(new Color(128, 128, 0)));
		goldButtonPanel.add(goldButton);
		defaultColorsPanel.add(goldButtonPanel);
		
		JPanel darkGreenButtonPanel = new JPanel();
		FlowLayout darkGreenButtonLayout = new FlowLayout();
		darkGreenButtonPanel.setLayout(darkGreenButtonLayout);
		JButton darkGreenButton = new JButton("<html><font color='#008000'>Green</font></html>");
		darkGreenButton.addActionListener(new ColorButtonListener(new Color(0, 128, 0)));
		darkGreenButtonPanel.add(darkGreenButton);
		defaultColorsPanel.add(darkGreenButtonPanel);
		
		JPanel aquaButtonPanel = new JPanel();
		FlowLayout aquaButtonLayout = new FlowLayout();
		aquaButtonPanel.setLayout(aquaButtonLayout);
		JButton aquaButton = new JButton("<html><font color='#008080'>Teal</font></html>");
		aquaButton.addActionListener(new ColorButtonListener(new Color(0, 128, 128)));
		aquaButtonPanel.add(aquaButton);
		defaultColorsPanel.add(aquaButtonPanel);
		
		JPanel darkBlueButtonPanel = new JPanel();
		FlowLayout darkBlueButtonLayout = new FlowLayout();
		darkBlueButtonPanel.setLayout(darkBlueButtonLayout);
		JButton darkBlueButton = new JButton("<html><font color='#000080'>Dark Blue</font></html>");
		darkBlueButton.addActionListener(new ColorButtonListener(new Color(0, 0, 128)));
		darkBlueButtonPanel.add(darkBlueButton);
		defaultColorsPanel.add(darkBlueButtonPanel);
		
		JPanel darkMagentaButtonPanel = new JPanel();
		FlowLayout darkMagentaButtonLayout = new FlowLayout();
		darkMagentaButtonPanel.setLayout(darkMagentaButtonLayout);
		JButton darkMagentaButton = new JButton("<html><font color='#800080'>Purple</font></html>");
		darkMagentaButton.addActionListener(new ColorButtonListener(new Color(128, 0, 128)));
		darkMagentaButtonPanel.add(darkMagentaButton);
		defaultColorsPanel.add(darkMagentaButtonPanel);

		
		JPanel pinkButtonPanel = new JPanel(new FlowLayout());
		JButton pinkButton = new JButton("<html><font color='#FF8888'>Pink</font></html>");
		pinkButton.addActionListener(new ColorButtonListener(new Color(255, 128, 128)));
		pinkButtonPanel.add(pinkButton);
		defaultColorsPanel.add(pinkButtonPanel);
		
		JPanel orangeButtonPanel = new JPanel(new FlowLayout());
		JButton orangeButton = new JButton("<html><font color='#FF8800'>Orange</font></html>");
		orangeButton.addActionListener(new ColorButtonListener(new Color(255, 128, 0)));
		orangeButtonPanel.add(orangeButton);
		defaultColorsPanel.add(orangeButtonPanel);
		
		JPanel whiteButtonPanel = new JPanel();
		FlowLayout whiteButtonLayout = new FlowLayout();
		whiteButtonPanel.setLayout(whiteButtonLayout);
		JButton whiteButton = new JButton("<html><font color='#FFFFFF'>White</font></html>");
		whiteButton.addActionListener(new ColorButtonListener(new Color(255, 255, 255)));
		whiteButtonPanel.add(whiteButton);
		defaultColorsPanel.add(whiteButtonPanel);
		
		JPanel silverButtonPanel = new JPanel();
		FlowLayout silverButtonLayout = new FlowLayout();
		silverButtonPanel.setLayout(silverButtonLayout);
		JButton silverButton = new JButton("<html><font color='#C0C0C0'>Silver</font></html>");
		silverButton.addActionListener(new ColorButtonListener(new Color(192, 192, 192)));
		silverButtonPanel.add(silverButton);
		defaultColorsPanel.add(silverButtonPanel);

		JPanel grayButtonPanel = new JPanel();
		FlowLayout grayButtonLayout = new FlowLayout();
		grayButtonPanel.setLayout(grayButtonLayout);
		JButton grayButton = new JButton("<html><font color='#808080'>Gray</font></html>");
		grayButton.addActionListener(new ColorButtonListener(new Color(128, 128, 128)));
		grayButtonPanel.add(grayButton);
		defaultColorsPanel.add(grayButtonPanel);
		
		JPanel blackButtonPanel = new JPanel();
		FlowLayout blackButtonLayout = new FlowLayout();
		blackButtonPanel.setLayout(blackButtonLayout);
		JButton blackButton = new JButton("<html><font color='#000000'>Black</font></html>");
		blackButton.addActionListener(new ColorButtonListener(new Color(0,0,0)));
		blackButtonPanel.add(blackButton);
		defaultColorsPanel.add(blackButtonPanel);
		
		
//		JPanel colorFillerPanel2 = new JPanel();
//		defaultColorsPanel.add(colorFillerPanel2);
		
		
		
		mainPanel.add(defaultColorsPanel);
		
		
		
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		this.add(lowerPanel, BorderLayout.SOUTH);
		
//		System.out.println("Dimensions of the red text field: " + redText.getSize().height + " high, " + redText.getSize().width + " across.");
		
	}
	
	
	public static void main(String [] args) {

		JDialog theFrame = new JDialog();
		theFrame.setSize(650, 350);
		
		BackgroundColorPopUpPanel panel = new BackgroundColorPopUpPanel(null, theFrame, true);
		
		theFrame.setContentPane(panel);
		

		theFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		
		theFrame.setVisible(true);
		
		
	}
	
	public void redColorFieldChanged() {
		
//		System.out.println("now in redColorFieldChanged");
		
		if(redText != null){
			
			String redColorText = redText.getText();
			
			if(redColorText == null || redColorText.length() == 0) {
				redComponent = -1;
				return;
			}
			
			int newRedComponent = -1;
			
			try {
				newRedComponent = Integer.parseInt(redColorText);
			} catch(NumberFormatException nfe) {
				JOptionPane.showMessageDialog(null, "The red, green, and blue text areas must contain numbers only", "Error", JOptionPane.ERROR_MESSAGE);
				if(redComponent == -1) {
					redText.setText("");
				} else {
					redText.setText(Integer.toString(redComponent));
				}
				return;
			}
			
			if(newRedComponent > 255 || newRedComponent < 0) {
				JOptionPane.showMessageDialog(null, "The number must be between 0 and 255, inclusive.", "Error", JOptionPane.ERROR_MESSAGE);
				if(redComponent == -1) {
					redText.setText("");
				} else {
					redText.setText(Integer.toString(redComponent));
				}
				return;
			}
			
			redComponent = newRedComponent;
			
		}
		
	}
	
	
	public void greenColorFieldChanged() {

//		System.out.println("now in greenColorFieldChanged");
		
		if(greenText != null){
			
			String greenColorText = greenText.getText();
			
			if(greenColorText == null || greenColorText.length() == 0) {
				greenComponent = -1;
				return;
			}
			
			int newGreenComponent = -1;
			
			try {
				newGreenComponent = Integer.parseInt(greenColorText);
			} catch(NumberFormatException nfe) {
				JOptionPane.showMessageDialog(null, "The red, green, and blue text areas must contain numbers only", "Error", JOptionPane.ERROR_MESSAGE);
				if(greenComponent == -1) {
					greenText.setText("");
				} else {
					greenText.setText(Integer.toString(greenComponent));
				}
				return;
			}
			
			if(newGreenComponent > 255 || newGreenComponent < 0) {
				JOptionPane.showMessageDialog(null, "The number must be between 0 and 255, inclusive.", "Error", JOptionPane.ERROR_MESSAGE);
				if(greenComponent == -1) {
					greenText.setText("");
				} else {
					greenText.setText(Integer.toString(greenComponent));
				}
				return;
			}
			
			greenComponent = newGreenComponent;
			
		}
		
	}
	
	public void blueColorFieldChanged() {

//		System.out.println("now in blueColorFieldChanged");
		
		if(blueText != null){
			
			String blueColorText = blueText.getText();
			
			if(blueColorText == null || blueColorText.length() == 0) {
				blueComponent = -1;
				return;
			}
			
			int newBlueComponent = -1;
			
			try {
				newBlueComponent = Integer.parseInt(blueColorText);
			} catch(NumberFormatException nfe) {
				JOptionPane.showMessageDialog(null, "The red, green, and blue text areas must contain numbers only", "Error", JOptionPane.ERROR_MESSAGE);
				if(blueComponent == -1) {
					blueText.setText("");
				} else {
					blueText.setText(Integer.toString(blueComponent));
				}
				return;
			}
			
			if(newBlueComponent > 255 || newBlueComponent < 0) {
				JOptionPane.showMessageDialog(null, "The number must be between 0 and 255, inclusive.", "Error", JOptionPane.ERROR_MESSAGE);
				if(blueComponent == -1) {
					blueText.setText("");
				} else {
					blueText.setText(Integer.toString(blueComponent));
				}
				return;
			}
			
			blueComponent = newBlueComponent;
			
		}
		
	}
	
	
	public void constructorBackup_BackgroundColorPopUpPanel(Color origColor) {
		
		if(origColor != null) {
			redComponent = origColor.getRed();
			greenComponent = origColor.getGreen();
			blueComponent = origColor.getBlue();
		}
		
		setLayout(new BorderLayout());
		
		JButton okButton = new JButton("OK");
		JButton cancelButton = new JButton("Cancel");
		
		JPanel lowerPanel = new JPanel();
		lowerPanel.setLayout(new BorderLayout());
		
		lowerPanel.add(cancelButton, BorderLayout.WEST);
		lowerPanel.add(okButton, BorderLayout.EAST);
		
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(2, 1));
		
		JPanel mainUpperPanel = new JPanel();
		
		GridBagLayout mainUpperLayout = new GridBagLayout();
		GridBagConstraints mainUpperConstraints = new GridBagConstraints();
		
		mainUpperConstraints.fill = GridBagConstraints.BOTH;
		mainUpperConstraints.weightx = 30.0;
		mainUpperConstraints.weighty = 1.0;
		mainUpperConstraints.gridwidth = 4;
		mainUpperConstraints.gridheight = 2;
		
		
		previewCanvas = new ColorCanvas();
		
		Border innerCanvasBorder = BorderFactory.createLineBorder(new Color(100, 100, 100));
		TitledBorder canvasBorder = BorderFactory.createTitledBorder(innerCanvasBorder);
		canvasBorder.setTitle("Color Preview");
		previewCanvas.setBorder(canvasBorder);
		
		mainUpperPanel.setLayout(mainUpperLayout);
		mainUpperLayout.setConstraints(previewCanvas, mainUpperConstraints);
		mainUpperPanel.add(previewCanvas);
		
		JPanel redLabelPanel = new JPanel();
		redLabelPanel.setLayout(new BorderLayout());
		JLabel redLabel = new JLabel("Red: ");
		redLabelPanel.add(redLabel, BorderLayout.CENTER);
		mainUpperConstraints.weightx = 1.0;
		mainUpperConstraints.weighty = 1.0;
		mainUpperConstraints.gridheight = 1;
		mainUpperConstraints.gridwidth = 1;
		mainUpperLayout.setConstraints(redLabelPanel, mainUpperConstraints);
		mainUpperPanel.add(redLabelPanel);
		
		JPanel redTextPanel = new JPanel();
		JPanel innerRedTextPanel = new JPanel();
		innerRedTextPanel.setLayout(new FlowLayout());
		redTextPanel.setLayout(new BorderLayout());
		redText = new JTextArea();
		redText.setColumns(3);
		redText.setSize(37, 20);
		redText.setMinimumSize(new Dimension(37, 20));
		redText.setPreferredSize(new Dimension(37, 20));
		redText.setMaximumSize(new Dimension(37, 20));
		Border redTextBorder = BorderFactory.createLoweredBevelBorder();
		redText.setBorder(redTextBorder);
//		innerRedTextPanel.add(redText);
		redTextPanel.add(redText, BorderLayout.CENTER);
		mainUpperLayout.setConstraints(redTextPanel, mainUpperConstraints);
		mainUpperPanel.add(redTextPanel);
		redText.addCaretListener(new CaretListener() {

			public void caretUpdate(CaretEvent arg0) {
				redColorFieldChanged();
			}
			
		});

		JPanel greenLabelPanel = new JPanel();
		greenLabelPanel.setLayout(new BorderLayout());
		JLabel greenLabel = new JLabel("Green: ");
		greenLabelPanel.add(greenLabel, BorderLayout.CENTER);
		mainUpperConstraints.weightx = 1.0;
		mainUpperLayout.setConstraints(greenLabelPanel, mainUpperConstraints);
		mainUpperPanel.add(greenLabelPanel);
		
		JPanel greenTextPanel = new JPanel();
		JPanel innerGreenTextPanel = new JPanel();
		innerGreenTextPanel.setLayout(new FlowLayout());
		greenTextPanel.setLayout(new BorderLayout());
		greenText = new JTextArea();
		greenText.setColumns(3);
		greenText.setSize(37, 20);
		greenText.setMinimumSize(new Dimension(37, 20));
		greenText.setPreferredSize(new Dimension(37, 20));
		greenText.setMaximumSize(new Dimension(37, 20));
		Border greenTextBorder = BorderFactory.createLoweredBevelBorder();
		greenText.setBorder(greenTextBorder);
//		innerGreenTextPanel.add(greenText);
		greenTextPanel.add(greenText, BorderLayout.CENTER);
		mainUpperLayout.setConstraints(greenTextPanel, mainUpperConstraints);
		mainUpperPanel.add(greenTextPanel);
		greenText.addCaretListener(new CaretListener() {

			public void caretUpdate(CaretEvent arg0) {
				greenColorFieldChanged();
			}
			
		});

		JPanel blueLabelPanel = new JPanel();
		blueLabelPanel.setLayout(new BorderLayout());
		JLabel blueLabel = new JLabel("Blue: ");
		blueLabelPanel.add(blueLabel, BorderLayout.CENTER);
		mainUpperConstraints.weightx = 1.0;
		mainUpperConstraints.gridwidth = GridBagConstraints.RELATIVE;
		mainUpperLayout.setConstraints(blueLabelPanel, mainUpperConstraints);
		mainUpperPanel.add(blueLabelPanel);
		
		JPanel blueTextPanel = new JPanel();
		JPanel innerBlueTextPanel = new JPanel();
		innerBlueTextPanel.setLayout(new FlowLayout());
		blueTextPanel.setLayout(new BorderLayout());
		blueText = new JTextArea();
		blueText.setColumns(3);
		blueText.setSize(37, 20);
		blueText.setMinimumSize(new Dimension(37, 20));
		blueText.setPreferredSize(new Dimension(37, 20));
		blueText.setMaximumSize(new Dimension(37, 20));
		Border blueTextBorder = BorderFactory.createLoweredBevelBorder();
		blueText.setBorder(blueTextBorder);
//		innerBlueTextPanel.add(blueText);
		blueTextPanel.add(blueText, BorderLayout.CENTER);
		mainUpperConstraints.gridwidth = GridBagConstraints.REMAINDER;
		mainUpperLayout.setConstraints(blueTextPanel, mainUpperConstraints);
		mainUpperPanel.add(blueTextPanel);
		blueText.addCaretListener(new CaretListener() {

			public void caretUpdate(CaretEvent arg0) {
				blueColorFieldChanged();
			}
			
		});
		
		
		JButton previewColorButton = new JButton("<--- Preview Color from RGB numbers");
		JPanel previewColorPanel = new JPanel();
		previewColorPanel.setLayout(new FlowLayout());
		previewColorPanel.add(previewColorButton);
		
		previewColorButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {

//				System.out.println("Dimensions of the red text field: " + redText.getSize().height + " high, " + redText.getSize().width + " across.");
				
			}
			
		});
		
		mainUpperConstraints.gridwidth = GridBagConstraints.RELATIVE;
		mainUpperConstraints.weightx = 3.0;
		mainUpperLayout.setConstraints(previewColorPanel, mainUpperConstraints);
		mainUpperPanel.add(previewColorPanel);
		
		JPanel fillerPanel = new JPanel();
		mainUpperConstraints.gridwidth = GridBagConstraints.REMAINDER;
		mainUpperLayout.setConstraints(fillerPanel, mainUpperConstraints);
		mainUpperPanel.add(fillerPanel);
		
		
		
		
		
		mainPanel.add(mainUpperPanel);
		mainPanel.add(new JLabel("dummy placeholder"));
		
		this.add(mainPanel, BorderLayout.CENTER);
		
		this.add(lowerPanel, BorderLayout.SOUTH);
		
//		System.out.println("Dimensions of the red text field: " + redText.getSize().height + " high, " + redText.getSize().width + " across.");
		
	}
	
	public void previewByNumbersButtonWasClicked() {
		
		if(redText == null || greenText == null || blueText == null) {
			
			return;
			
		}
		
		String redTextStr = redText.getText();
		String greenTextStr = greenText.getText();
		String blueTextStr = blueText.getText();
		
		if(redTextStr == null || redTextStr.length() == 0) {
			JOptionPane.showMessageDialog(null, "Error:  nothing has been entered for the red text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		int tempRedInt, tempGreenInt, tempBlueInt;
		
		try {
			tempRedInt = Integer.parseInt(redTextStr);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(null, "Error:  a number between 0 and 255 must be entered for the red text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if(tempRedInt < 0 || tempRedInt > 255) {
			JOptionPane.showMessageDialog(null, "Error:  a number between 0 and 255 must be entered for the red text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		
		if(greenTextStr == null || greenTextStr.length() == 0) {
			JOptionPane.showMessageDialog(null, "Error:  nothing has been entegreen for the green text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		try {
			tempGreenInt = Integer.parseInt(greenTextStr);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(null, "Error:  a number between 0 and 255 must be entered for the green text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}

		if(tempGreenInt < 0 || tempGreenInt > 255) {
			JOptionPane.showMessageDialog(null, "Error:  a number between 0 and 255 must be entered for the green text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		
		
		if(blueTextStr == null || blueTextStr.length() == 0) {
			JOptionPane.showMessageDialog(null, "Error:  nothing has been entered for the blue text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		try {
			tempBlueInt = Integer.parseInt(blueTextStr);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(null, "Error:  a number between 0 and 255 must be entered for the blue text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}

		if(tempBlueInt < 0 || tempBlueInt > 255) {
			JOptionPane.showMessageDialog(null, "Error:  a number between 0 and 255 must be entered for the blue text field", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		redComponent = tempRedInt;
		greenComponent = tempGreenInt;
		blueComponent = tempBlueInt;
		
		
		Color newColor = new Color(redComponent, greenComponent, blueComponent);
		
		previewCanvas.setColor(newColor);
		previewCanvas.refresh();
		
		
		
	}
	
	public class ColorButtonListener implements ActionListener {

		private Color color;
		
		public ColorButtonListener(Color theColor) {
			color = theColor;
		}
		
		public void actionPerformed(ActionEvent arg0) {
			
			redComponent = color.getRed();
			greenComponent = color.getGreen();
			blueComponent = color.getBlue();
			
			previewCanvas.setColor(color);
			previewCanvas.refresh();
			
		}
		
	}
	
	public void uponOkClick() {
		
		if(redComponent < 0 || redComponent > 255 
				|| greenComponent < 0 || greenComponent > 255
				|| blueComponent < 0 || blueComponent > 255) {
			
			resultColor = null;
			
		} else {
		
			resultColor = new Color(redComponent, greenComponent, blueComponent, 255);
		}
		parent.dispose();
		
	}
	
	public void uponCancelClick(boolean isAlreadyClosing) {
		resultColor = null;
		
		if(!isAlreadyClosing) {
			parent.dispose();
		}
	}
	
	public Color getResultColor() {
		return resultColor;
	}
	
	public boolean shouldUseColorForAllImages() {
		if(shouldUseForAllImages == null || !shouldUseForAllImages.isSelected()) {
			return false;
		} else {
			return true;
		}
	}
	
	
	public static void popUpColorSelectDialog(SharedColor sharedColor, MicroColorCanvas microColorCanvas) {
		
		
		JDialog colorPopupDialog = new JDialog();
		BackgroundColorPopUpPanel colorPopupPanel = new BackgroundColorPopUpPanel(sharedColor.getColor(), colorPopupDialog, false);
		
		colorPopupDialog.setContentPane(colorPopupPanel);
		
//		System.out.println("about to call colorPopupDialog.setVisible...");
		
		colorPopupDialog.setVisible(true);
		
		
		Color newBgColor = colorPopupPanel.getResultColor();
		
		
		
		if(newBgColor == null) {
			
//			System.out.println("no color was selected!");
			
		} else {
//			System.out.println("just returned from colorPopupDialog.setVisible!  red: " + newBgColor.getRed() + ", green:  " + newBgColor.getGreen() + ", blue: " + newBgColor.getBlue());
			
			sharedColor.setColor(newBgColor);
			
			microColorCanvas.refresh();
			
		}
		
	}
	
}
